<?php
/**
 * Button X
 *
 * This file is used to register WooCommerce related functionality of the plugin.
 *
 * @package Buttons X
 * @since 0.1
 */

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'BtnsxWoo' ) ) {
	class BtnsxWoo {

		private static $instance;

		/**
		 * Initiator
		 * @since 0.1
		 */
		public static function init() {
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 0.1
		 */
		public function __construct() {
			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
				global $btnsx_settings;
				add_filter( 'btnsx_settings_filter', array( $this, 'btnsx_woo_settings' ) );
				add_action( 'woocommerce_after_single_product_summary', array( $this, 'btnsx_woo_after_single_product_summary' ), 51 );
				add_action( 'woocommerce_before_single_product', array( $this, 'btnsx_woo_before_single_product' ), 51 );
				add_action( 'woocommerce_before_single_product_summary', array( $this, 'btnsx_woo_before_single_product_summary' ), 51 );
				add_action( 'woocommerce_sidebar', array( $this, 'btnsx_woo_sidebar' ), 51 );
				add_action( 'woocommerce_single_product_summary', array( $this, 'btnsx_woo_single_product_summary' ), 51 );
				if( isset( $btnsx_settings[ 'woo_order_button_html' ] ) && $btnsx_settings[ 'woo_order_button_html' ] != '' ) {
					if( $btnsx_settings[ 'woo_order_button_html' ] != 'none' ) {
						add_filter( 'woocommerce_order_button_html', array( $this, 'btnsx_woo_order_button_html' ), 51 );
					}
				}
				if( isset( $btnsx_settings[ 'woo_pay_order_button_html' ] ) && $btnsx_settings[ 'woo_pay_order_button_html' ] != '' ) {
					if( $btnsx_settings[ 'woo_pay_order_button_html' ] != 'none' ) {
						add_filter( 'woocommerce_pay_order_button_html', array( $this, 'btnsx_woo_pay_order_button_html' ), 51 );
					}
				}
				if( isset( $btnsx_settings[ 'woo_shop_archive_button' ] ) && $btnsx_settings[ 'woo_shop_archive_button' ] != '' ) {
					add_action( 'woocommerce_after_shop_loop_item', array( $this, 'btnsx_woo_after_shop_loop_item' ), 51 );
				}
				if( isset( $btnsx_settings[ 'woo_shop_archive_remove_default' ] ) && $btnsx_settings[ 'woo_shop_archive_remove_default' ] != '' ) {
					add_action( 'init', array( $this, 'btnsx_woo_shop_archive_remove_default' ) );
				}
			}
		}

		/**
		 * Buttons X - Options Filter
		 */
		function btnsx_woo_settings( array $options ) {
			global $btnsx_settings;
			global $wpdb;
			   	$btnsx_post = 'buttons-x';
			   	$btnsx_social = 'buttons-x-social';
			   	$btnsx_dual = 'buttons-x-dual';
				$btnsx_post_status = 'publish';
		        $btnsx = $wpdb->get_results( $wpdb->prepare(
		            "SELECT ID, post_title, post_type
		                FROM $wpdb->posts 
		                WHERE $wpdb->posts.post_type = %s
		                AND $wpdb->posts.post_status = %s
		                ORDER BY ID DESC",
		            $btnsx_post,
		            $btnsx_post_status
		        ) );
		        $btnsx_social = $wpdb->get_results( $wpdb->prepare(
		            "SELECT ID, post_title, post_type
		                FROM $wpdb->posts 
		                WHERE $wpdb->posts.post_type = %s
		                AND $wpdb->posts.post_status = %s
		                ORDER BY ID DESC",
		            $btnsx_social,
		            $btnsx_post_status
		        ) );
		        $btnsx_dual = $wpdb->get_results( $wpdb->prepare(
		            "SELECT ID, post_title, post_type
		                FROM $wpdb->posts 
		                WHERE $wpdb->posts.post_type = %s
		                AND $wpdb->posts.post_status = %s
		                ORDER BY ID DESC",
		            $btnsx_dual,
		            $btnsx_post_status
		        ) );
		        $btns = array(
		        	'' => '',
		        	'none' => __( 'None', 'btnsx' )
		        );
		        foreach ( $btnsx as $btn ) {
					$btn_id = $btn->ID;
					$btn_name = $btn->post_title;
					$btn_type = $btn->post_type;
					if( $btn_name == '' ){
						$btn_name = __('( No Name )','btnsx');
					}
					$btns[$btn_id.'_'.$btn_type] = $btn_name;
				}
				foreach ( $btnsx_social as $btn ) {
					$btn_id = $btn->ID;
					$btn_name = $btn->post_title;
					$btn_type = $btn->post_type;
					if( $btn_name == '' ){
						$btn_name = __('( No Name )','btnsx');
					}
					$btns[$btn_id.'_'.$btn_type] = $btn_name;
				}
				foreach ( $btnsx_dual as $btn ) {
					$btn_id = $btn->ID;
					$btn_name = $btn->post_title;
					$btn_type = $btn->post_type;
					if( $btn_name == '' ){
						$btn_name = __('( No Name )','btnsx');
					}
					$btns[$btn_id.'_'.$btn_type] = $btn_name;
				}
			$options[] = array(
    			'icon_class'	=>	'fa fa-shopping-cart',
    			'text'			=>	__( 'WooCommerce', 'btnsx' ),
    			'inner_group'	=>	array(
    				array(
						'text'			=>	__( 'Single Product Page', 'btnsx' ),
						'elements'		=>	array(
	        				array(
								'type'			=>	'select',
								'name'			=>	'woo_after_single_product_summary',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'After Single Product', 'btnsx' ),
								'tooltip'		=>	__( 'Add button on WooCommerce single product page after product summary', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_after_single_product_summary'] ) && $btnsx_settings['woo_after_single_product_summary'] != '' ? $btnsx_settings['woo_after_single_product_summary'] : ''
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_single_product_summary',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'After Single Product Summary', 'btnsx' ),
								'tooltip'		=>	__( 'Add button on WooCommerce single product page after product summary', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_single_product_summary'] ) && $btnsx_settings['woo_single_product_summary'] != '' ? $btnsx_settings['woo_single_product_summary'] : ''
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_before_single_product',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Before Product', 'btnsx' ),
								'tooltip'		=>	__( 'Add button on WooCommerce single product page before product', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_before_single_product'] ) && $btnsx_settings['woo_before_single_product'] != '' ? $btnsx_settings['woo_before_single_product'] : ''
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_before_single_product_summary',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Before Product Summary', 'btnsx' ),
								'tooltip'		=>	__( 'Add button on WooCommerce single product page before product summary', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_before_single_product_summary'] ) && $btnsx_settings['woo_before_single_product_summary'] != '' ? $btnsx_settings['woo_before_single_product_summary'] : ''
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_sidebar',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Sidebar', 'btnsx' ),
								'tooltip'		=>	__( 'Add button on WooCommerce single product page sidebar', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_sidebar'] ) && $btnsx_settings['woo_sidebar'] != '' ? $btnsx_settings['woo_sidebar'] : ''
							)
						)
					),
					array(
						'text'			=>	__( 'Checkout Page', 'btnsx' ),
						'elements'		=>	array(
							array(
								'type'			=>	'html',
								'value'			=>	'<div class="col s12" style="margin-bottom:10px;"><p style="padding:10px;background-color:#fff;color:#c0392b;border-radius:4px;border:1px solid #c0392b;margin-top:0;">Experimental feature use with caution</p></div>'
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_order_button_html',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Order Button', 'btnsx' ),
								'tooltip'		=>	__( 'Replace checkout page button.', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_order_button_html'] ) && $btnsx_settings['woo_order_button_html'] != '' ? $btnsx_settings['woo_order_button_html'] : ''
							)
						)
					),
					array(
						'text'			=>	__( 'Pay Order Page', 'btnsx' ),
						'elements'		=>	array(
							array(
								'type'			=>	'html',
								'value'			=>	'<div class="col s12" style="margin-bottom:10px;"><p style="padding:10px;background-color:#fff;color:#c0392b;border-radius:4px;border:1px solid #c0392b;margin-top:0;">Experimental feature use with caution</p></div>'
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_pay_order_button_html',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Pay Order Button', 'btnsx' ),
								'tooltip'		=>	__( 'Replace pay for order page button.', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_pay_order_button_html'] ) && $btnsx_settings['woo_pay_order_button_html'] != '' ? $btnsx_settings['woo_pay_order_button_html'] : ''
							)
						)
					),
					array(
						'text'			=>	__( 'Shop Archive Pages', 'btnsx' ),
						'elements'		=>	array(
							array(
								'type'			=>	'html',
								'value'			=>	'<div class="col s12" style="margin-bottom:10px;"><p style="padding:10px;background-color:#fff;color:#c0392b;border-radius:4px;border:1px solid #c0392b;margin-top:0;">' . __('Experimental feature use with caution','btnsx') . '</p></div>'
							),
							array(
								'type'			=>	'select',
								'name'			=>	'woo_shop_archive_button',
								'class'			=>	'btnsx-select',
								'label'			=>	__( 'Archive Product Button', 'btnsx' ),
								'tooltip'		=>	__( 'Add/Replace button on shop archive pages for every product.', 'btnsx' ),
								'options'		=>	$btns,
								'value'			=>	isset( $btnsx_settings['woo_shop_archive_button'] ) && $btnsx_settings['woo_shop_archive_button'] != '' ? $btnsx_settings['woo_shop_archive_button'] : ''
							),
							array(
								'type'			=>	'checkbox',
								'id'			=>	'woo_shop_archive_remove_default',
								'name'			=>	'woo_shop_archive_remove_default',
								'label'			=>	__( 'Remove Other Buttons', 'btnsx' ),
								'tooltip'		=>	__( 'Enabling this removes default buttons.', 'btnsx' ),
								'class'			=>	'btnsx-checkbox',
								'value'			=>	isset( $btnsx_settings['woo_shop_archive_remove_default'] ) && $btnsx_settings['woo_shop_archive_remove_default'] != '' ? $btnsx_settings['woo_shop_archive_remove_default'] : '0'
							)
						)
					)
				)
			);
			return $options;
		}

		public function settings_check( $key ) {
			global $btnsx_settings;
			if( isset( $btnsx_settings[ $key ] ) && $btnsx_settings[ $key ] != '' ) {
				$type = explode('_',$btnsx_settings[$key]);
				if( $btnsx_settings[ $key ] != 'none' ){
					if( $type[1] == 'buttons-x' ){
						echo do_shortcode('[btnsx id="'. $type[0] .'"]');
					}elseif( $type[1] == 'buttons-x-social' ){
						echo do_shortcode('[btnsx_social id="'. $type[0] .'"]');
					}elseif( $type[1] == 'buttons-x-dual' ){
						echo do_shortcode('[btnsx_dual id="'. $type[0] .'"]');
					}
				}
			}
		}

		public function btnsx_woo_after_single_product_summary() {
		    $this->settings_check( 'woo_after_single_product_summary' );
		}
		public function btnsx_woo_before_single_product() {
		    $this->settings_check( 'woo_before_single_product' );
		}
		public function btnsx_woo_before_single_product_summary() {
		    $this->settings_check( 'woo_before_single_product_summary' );
		}
		public function btnsx_woo_sidebar() {
		    $this->settings_check( 'woo_sidebar' );
		}
		public function btnsx_woo_single_product_summary() {
		    $this->settings_check( 'woo_single_product_summary' );
		}
		public function button_settings_check( $key ) {
			global $btnsx_settings;
			$value = $btnsx_settings[ $key ];
			if( $value != 'none' ){
				$btn = new Btnsx();
				$output = $btn->shortcode( array(
					'id' => $value,
					'link' => ''
				) );
				ob_start();
				?>
					<script type="text/javascript">
						jQuery(document).ready(function($){
							$('<?php echo "#btnsx-" . $value; ?>').on('click',function(){
								$('#place_order').trigger('click');
								return false;
							});
						});
					</script>
				<?php
				$script = ob_get_clean();
				return $script . $output . '<input type="submit" class="button alt" name="woocommerce_checkout_place_order" id="place_order" value="" data-value="' . __( 'Place Order','btnsx' ) . '" style="display:none;" />';
			}
		}
		public function btnsx_woo_order_button_html() {
			return $this->button_settings_check( 'woo_order_button_html' );
		}
		public function btnsx_woo_pay_order_button_html() {
			return $this->button_settings_check( 'woo_pay_order_button_html' );
		}
		public function btnsx_woo_after_shop_loop_item() {
			$this->settings_check( 'woo_shop_archive_button' );
		}
		public function btnsx_woo_shop_archive_remove_default() {
			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
		}
	} // Woo Class
}

/**
 *  Kicking this off
 */

$btn_options = new BtnsxWoo();
$btn_options->init();